/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.contextproviders;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.web.ContextProvider;
import io.vavr.collection.HashMap;
import java.util.Map;
import java.util.UUID;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.components.TraceComponents;
import vivid.trace.components.UserPreferences;
import vivid.trace.license.AddOnLicensing;

public class IssueTraceContextProvider
implements ContextProvider {
    private static final String ISSUE_CONTEXT_KEY = "issue";
    private final AddOnLicensing addOnLicensing;
    private final AddOnPreconditions addOnPreconditions;
    private final Factory f;
    private final ProjectConfigurations projectConfigurations;
    private final UserPreferences userPreferences;
    private Map<String, String> additionalParams;

    public IssueTraceContextProvider(AddOnLicensing addOnLicensing, AddOnPreconditions addOnPreconditions, Factory factory, ProjectConfigurations projectConfigurations, UserPreferences userPreferences) {
        this.addOnLicensing = addOnLicensing;
        this.addOnPreconditions = addOnPreconditions;
        this.f = factory;
        this.projectConfigurations = projectConfigurations;
        this.userPreferences = userPreferences;
    }

    public void init(Map<String, String> params) {
        this.additionalParams = params;
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get(ISSUE_CONTEXT_KEY);
        return ((HashMap)HashMap.ofAll(this.additionalParams).merge(HashMap.ofAll(IssueTraceContextProvider.contextMap(this.addOnLicensing, this.f, issue, this.addOnPreconditions, this.projectConfigurations, this.userPreferences)))).toJavaMap();
    }

    public static Map<String, Object> contextMap(AddOnLicensing addOnLicensing, Factory factory, Issue issue, AddOnPreconditions addOnPreconditions, ProjectConfigurations projectConfigurations, UserPreferences userPreferences) {
        Project project = issue.getProjectObject();
        return ((HashMap)((HashMap)((HashMap)((HashMap)((HashMap)((HashMap)HashMap.ofAll(TraceComponents.inContextVelocityParams(issue.getKey(), project, addOnLicensing, addOnPreconditions, factory, userPreferences)).put((Object)"currentIssueKey", (Object)issue.getKey())).put("inContext", ISSUE_CONTEXT_KEY)).put("jiraMajorVersion", factory.jiraMajorVersion())).put("issue-context-trace-display-format", projectConfigurations.getIssueContextTraceDisplayFormat(project))).put("labelOrphans", "false")).put("renderTaskId", UUID.randomUUID().toString())).toJavaMap();
    }
}

