/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.customfield;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemBuilder;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.I18n;
import vivid.trace.customfield.DirectionsCFType;

@Named
public class DirectionsCustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(DirectionsCustomFieldManager.class);
    private static final String CUSTOM_FIELD_TYPE_KEY = "vivid.trace:VTDirections-custom-field-type";
    private static final String CUSTOM_FIELD_SEARCHER_KEY = "VTDirections-custom-field-searcher";
    private final CustomFieldManager customFieldManager;
    private final Option<I18n.ResolverAdapter> i18nResolverAdapterOption;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final ReindexMessageManager reindexMessageManager;

    @Inject
    public DirectionsCustomFieldManager(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport ManagedConfigurationItemService managedConfigurationItemService, @ComponentImport ReindexMessageManager reindexMessageManager) {
        this.customFieldManager = Objects.requireNonNull(customFieldManager);
        Objects.requireNonNull(i18nResolver);
        this.i18nResolverAdapterOption = Option.of((arg_0, arg_1) -> ((I18nResolver)i18nResolver).getText(arg_0, arg_1));
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.reindexMessageManager = Objects.requireNonNull(reindexMessageManager);
    }

    private String getCustomFieldTypeKey(CustomField field) {
        if (field == null) {
            return null;
        }
        CustomFieldType customFieldType = field.getCustomFieldType();
        if (customFieldType == null) {
            return null;
        }
        return customFieldType.getKey();
    }

    private String getCustomFieldSearcherKey(CustomField field) {
        if (field == null) {
            return null;
        }
        CustomFieldSearcher customFieldSearcher = field.getCustomFieldSearcher();
        if (customFieldSearcher == null) {
            return null;
        }
        CustomFieldSearcherModuleDescriptor descriptor = customFieldSearcher.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getKey();
    }

    public boolean isCustomFieldConfigurationValid() {
        log.debug("Verifying custom field '{}'", (Object)"VTDirections");
        CustomField field = DirectionsCFType.getCustomField(this.customFieldManager);
        boolean valid = true;
        if (field == null) {
            valid = false;
        } else if (!CUSTOM_FIELD_TYPE_KEY.equals(this.getCustomFieldTypeKey(field))) {
            String key = "(UNKNOWN)";
            CustomFieldType cft = field.getCustomFieldType();
            if (cft != null) {
                key = cft.getKey();
            }
            log.error("Custom field {}'s type must be '{}' but is actually '{}'", new Object[]{"VTDirections", CUSTOM_FIELD_TYPE_KEY, key});
            valid = false;
        } else if (!CUSTOM_FIELD_SEARCHER_KEY.equals(this.getCustomFieldSearcherKey(field))) {
            CustomFieldSearcherModuleDescriptor d;
            String key = "(UNKNOWN)";
            CustomFieldSearcher cfs = field.getCustomFieldSearcher();
            if (cfs != null && (d = cfs.getDescriptor()) != null) {
                key = d.getKey();
            }
            log.error("Custom field {}'s field searcher must be '{}' but is actually '{}'", new Object[]{"VTDirections", CUSTOM_FIELD_SEARCHER_KEY, key});
            valid = false;
        } else if (!field.isAllIssueTypes()) {
            log.error("Custom field {} must be available to all issue types but is not", (Object)"VTDirections");
            valid = false;
        } else if (!field.isGlobal()) {
            log.error("Custom field {} must be global but is not", (Object)"VTDirections");
            valid = false;
        } else if (!field.isEnabled()) {
            log.error("Custom field {} must be enabled but is not", (Object)"VTDirections");
            valid = false;
        }
        return valid;
    }

    private void createCustomField(String createVerb) {
        block2: {
            try {
                CustomField field = this.customFieldManager.createCustomField("VTDirections", I18n.getText(this.i18nResolverAdapterOption, "vivid.trace.custom-field.description", new Serializable[0]), this.customFieldManager.getCustomFieldType(CUSTOM_FIELD_TYPE_KEY), this.customFieldManager.getCustomFieldSearcher("vivid.trace:VTDirections-custom-field-searcher"), Collections.singletonList(GlobalIssueContext.getInstance()), Collections.singletonList(null));
                this.idempotentSetCustomFieldAccessLevel(field, ConfigurationItemAccessLevel.LOCKED);
                this.reindexMessageManager.pushMessage(null, I18n.getText(this.i18nResolverAdapterOption, "vivid.trace.custom-field.reindex-message", new Serializable[0]));
                log.warn("{} custom field {}; A re-index must be performed before Vivid Trace will operate properly.", (Object)createVerb, (Object)"VTDirections");
            }
            catch (Exception e) {
                log.warn("Encountered exception while attempting to create custom field 'VTDirections'", (Throwable)e);
                CustomField field = DirectionsCFType.getCustomField(this.customFieldManager);
                if (field == null) break block2;
                this.idempotentSetCustomFieldAccessLevel(field, ConfigurationItemAccessLevel.SYS_ADMIN);
            }
        }
    }

    public void idempotentCreateAndLockCustomField() {
        this.customFieldManager.refresh();
        if (this.isCustomFieldConfigurationValid()) {
            return;
        }
        CustomField field = DirectionsCFType.getCustomField(this.customFieldManager);
        if (field == null) {
            this.createCustomField("Created");
        } else {
            try {
                this.idempotentSetCustomFieldAccessLevel(field, ConfigurationItemAccessLevel.SYS_ADMIN);
                this.customFieldManager.removeCustomField(field);
                this.createCustomField("Recreated");
            }
            catch (RemoveException e) {
                log.error("Could not remove custom field {} while trying to recreate it", (Object)"VTDirections");
            }
        }
    }

    private void idempotentSetCustomFieldAccessLevel(CustomField field, ConfigurationItemAccessLevel desiredAccessLevel) {
        ManagedConfigurationItem update;
        ServiceOutcome o;
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        if (item.getConfigurationItemAccessLevel() != desiredAccessLevel && (o = this.managedConfigurationItemService.updateManagedConfigurationItem(update = ManagedConfigurationItemBuilder.builder((ManagedConfigurationItem)item).setManaged(true).setConfigurationItemAccessLevel(desiredAccessLevel).setDescriptionI18nKey(I18n.getText(this.i18nResolverAdapterOption, "vivid.trace.custom-field.managed-description", new Serializable[0])).build())).getErrorCollection().hasAnyErrors()) {
            log.warn("Could not set access level for custom field '{}' to {} using ManagedConfigurationItemService: {}", new Object[]{"VTDirections", desiredAccessLevel.toString(), o.getErrorCollection().toString()});
        }
    }
}

