/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc.system;

import com.atlassian.jira.issue.Issue;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.ifc.system.SystemFieldCollector;

public class SubTaskSystemFieldCollector
implements SystemFieldCollector {
    public static final String ATTRIBUTE_KEY = ":jira.issue-field.system/sub-task-issues";

    @Override
    public String id() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public String i18nKey() {
        return "issue.field.subtasks";
    }

    @Override
    public void collect(Issue issue, Map<String, Object> attributes, IssueFieldCollector context) {
        Collection subtasks = issue.getSubTaskObjects();
        if (subtasks != null && !subtasks.isEmpty()) {
            IssueFieldCollector.putJoinedStringsInAttributes(attributes, ATTRIBUTE_KEY, subtasks.stream().map(Issue::getKey).sorted().collect(Collectors.toList()));
        }
    }
}

