/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ifc.system;

import com.atlassian.jira.issue.Issue;
import java.util.Map;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.ifc.system.SystemFieldCollector;

public class TimeEstimateSpentSystemFieldCollector
implements SystemFieldCollector {
    private static final String ATTRIBUTE_KEY = ":jira.issue-field.system/time-estimate-spent";

    @Override
    public String id() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public String i18nKey() {
        return "issue.field.timespent";
    }

    @Override
    public void collect(Issue issue, Map<String, Object> attributes, IssueFieldCollector context) {
        Long timeSpent = issue.getTimeSpent();
        if (timeSpent != null) {
            IssueFieldCollector.putStringInAttributes(attributes, ATTRIBUTE_KEY, context.formatShortDuration(timeSpent));
        }
    }
}

