/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;
import vivid.lib.I18n;
import vivid.lib.Primitives;
import vivid.lib.atlassian.Servlets;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE20UnknownObject;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.TraceComponents;
import vivid.trace.components.TraceConfigurationMRU;
import vivid.trace.datatypes.TraceConfigurations;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jira.servlets.PageServlet;
import vivid.trace.license.AddOnLicensing;
import vivid.trace.onboarding.BundledTraceConfigurations;

public class TraceServlet
extends PageServlet {
    private static final long serialVersionUID = 1L;
    private static final String TRACE_CONFIGURATION_ID_REQUEST_PARAMETER = "trace";
    private static final String TRACE_CONFIGURATION_REQUEST_PARAMETER = "traceConfiguration";
    private static final String VIEW_TEMPLATE_FILENAME = "/trace/trace.vm";
    public static final String SERVLET_URI_FRAGMENT = "/secure/trace/";
    private final AddOnLicensing addOnLicensing;
    private final AddOnPreconditions addOnPreconditions;
    private final BundledTraceConfigurations bundledTraceConfigurations;
    private final transient TraceConfigurations traceConfigurations;
    private final transient TraceComponents traceComponents;
    private final TraceConfigurationMRU traceConfigurationMRU;

    public TraceServlet(AddOnLicensing addOnLicensing, AddOnPreconditions addOnPreconditions, BundledTraceConfigurations bundledTraceConfigurations, Factory factory, TraceConfigurations traceConfigurations, TraceComponents traceComponents, TraceConfigurationMRU traceConfigurationMRU) {
        super(factory);
        this.addOnLicensing = addOnLicensing;
        this.addOnPreconditions = addOnPreconditions;
        this.bundledTraceConfigurations = bundledTraceConfigurations;
        this.traceConfigurations = traceConfigurations;
        this.traceComponents = traceComponents;
        this.traceConfigurationMRU = traceConfigurationMRU;
    }

    private static Option<String> getRequestParameter(HttpServletRequest request, String parameterName) {
        String param = request.getParameter(parameterName);
        return param != null && param.length() >= 1 ? Option.of(param) : Option.none();
    }

    private static Option<String> getSessionAttribute(HttpServletRequest request, String attributeName) {
        String attr = (String)request.getSession().getAttribute(attributeName);
        return attr != null && attr.length() >= 1 ? Option.of(attr) : Option.none();
    }

    private static Option<Integer> getTraceConfigurationIdRequestParameter(HttpServletRequest request) {
        Option<String> traceConfigurationIdOptional = TraceServlet.getRequestParameter(request, TRACE_CONFIGURATION_ID_REQUEST_PARAMETER);
        if (!traceConfigurationIdOptional.isDefined()) {
            return Option.none();
        }
        return Primitives.asInteger(traceConfigurationIdOptional.get());
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        boolean isAnonymousUser = user == null;
        boolean hasVisibleProjects = Jira.hasVisibleProjects(this.f.permissionManager, user);
        if (isAnonymousUser && !hasVisibleProjects) {
            Servlets.redirectToLogin(this.f.loginUriProvider, request, response);
            return;
        }
        this.bundledTraceConfigurations.favoriteBundledTraceConfigurations(user);
        response.setContentType("text/html;charset=utf-8");
        this.f.getRequiredResources().requireContext("vt.trace");
        Map<String, Map<String, String>> artifactTypeMap = this.traceComponents.artifactTypeMap();
        String artifactTypeMapJson = Jackson.writeValueAsString(artifactTypeMap);
        Map<Long, Map<String, String>> issueLinkTypeMap = this.traceComponents.issueLinkTypeMap();
        String issueLinkTypeMapJson = Jackson.writeValueAsString(issueLinkTypeMap);
        boolean isUserAuthenticated = this.f.jiraAuthenticationContext.isLoggedInUser();
        boolean isUserJiraAdmin = this.f.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.f.jiraAuthenticationContext.getLoggedInUser());
        Map params = ((HashMap)((HashMap)((HashMap)((HashMap)((HashMap)((HashMap)HashMap.of("artifactTypes", this.traceComponents.artifactTypes(Option.none()), "artifactTypeMap", StringEscapeUtils.escapeEcmaScript((String)artifactTypeMapJson), "contextPath", this.f.getContextPath(), "defaultTraceConfiguration", TraceComponents.defaultTraceConfigurationJavaScriptEscaped(), "i18n", I18n.i18nGetTextMethod(this.f.i18nResolverAdapterOption), "itemCardLayout", StringEscapeUtils.escapeEcmaScript((String)"[{:id \":jira.issue-field.system/issue-type\" :x 0 :y 0 :w 1 :h 1}{:id \":jira.issue-field.system/key\" :x 1 :y 0 :w 4 :h 1}{:id \":jira.issue-field.system/assignee\" :x 5 :y 0 :w 5 :h 1}{:id \":jira.issue-field.system/priority\" :x 0 :y 1 :w 1 :h 1}{:id \":jira.issue-field.system/summary\" :x 1 :y 1 :w 9 :h 2}]"), "issueLinkTypes", this.traceComponents.issueLinkTypes(Option.none()), "issueLinkTypeMap", StringEscapeUtils.escapeEcmaScript((String)issueLinkTypeMapJson), "isUserAuthenticated", isUserAuthenticated).put((Object)"isUserJiraAdmin", (Object)isUserJiraAdmin)).put("blankTraceConfiguration", TraceComponents.defaultTraceConfigurationJavaScriptEscaped())).put("vt-is-jira-administrator", (Object)Jira.hasJiraAdministratorsPermission(this.f.globalPermissionManager, user))).merge(HashMap.ofAll(TraceComponents.licenseBannerVelocityParams(this.addOnLicensing, this.f)))).put("relationsSeedIssuesArg", "")).merge(super.velocityParams(request))).toJavaMap();
        Map<String, String> errorMessages = this.addOnPreconditions.getViolationsOfTypes(this.f.newHtmlMessageReportingAdapter(), MessageType.ERROR, new MessageType[0]).asMap();
        if (!errorMessages.isEmpty()) {
            params.put("messages", errorMessages);
        }
        Option<Integer> traceConfigurationIdOptional = TraceServlet.getTraceConfigurationIdRequestParameter(request);
        Option<String> traceConfigurationOptional = TraceServlet.getSessionAttribute(request, SessionVar.VIVID_TRACE_TRACE_CONFIGURATION.name());
        if (traceConfigurationOptional.isDefined()) {
            String traceConfiguration = traceConfigurationOptional.get();
            params.put("initialTraceConfiguration", StringEscapeUtils.escapeEcmaScript((String)("{\"configuration\": " + traceConfiguration + "}")));
            request.getSession().removeAttribute(SessionVar.VIVID_TRACE_TRACE_CONFIGURATION.name());
        } else if (traceConfigurationIdOptional.isDefined()) {
            Integer traceConfigurationId = traceConfigurationIdOptional.get();
            Option<TraceConfigurationAO> traceConfigurationAoOptional = this.traceConfigurations.getTraceConfiguration(traceConfigurationId, user);
            if (traceConfigurationAoOptional.isDefined()) {
                Map<String, Object> map = this.traceConfigurations.getAsMap(user, traceConfigurationAoOptional.get(), Collections.emptyList());
                String traceConfigurationJson = Jackson.writeValueAsString(map);
                params.put("initialTraceConfiguration", StringEscapeUtils.escapeEcmaScript((String)traceConfigurationJson));
                this.traceConfigurationMRU.updateOrInsert(traceConfigurationId, user);
            } else {
                Message message = VTE20UnknownObject.message(this.f.i18nResolverAdapterOption, "vivid.trace.phrase.trace-id", traceConfigurationIdOptional.get().toString());
                params.put("messages", HashMap.of(message.getCodeOption().get(), StringEscapeUtils.escapeEcmaScript((String)message.getMessage())).toJavaMap());
            }
        }
        VelocityTemplatingEngine.RenderRequest renderRequest = this.f.velocityTemplatingEngine.render(TemplateSources.file((String)VIEW_TEMPLATE_FILENAME)).applying(params);
        String responseHtml = renderRequest.asHtml();
        response.getWriter().print(responseHtml);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Option<String> traceConfigurationOptional = TraceServlet.getRequestParameter(request, TRACE_CONFIGURATION_REQUEST_PARAMETER);
        if (traceConfigurationOptional.isDefined()) {
            request.getSession().setAttribute(SessionVar.VIVID_TRACE_TRACE_CONFIGURATION.name(), (Object)traceConfigurationOptional.get());
        }
        response.sendRedirect(this.f.getContextPath() + SERVLET_URI_FRAGMENT);
    }

    private static enum SessionVar {
        VIVID_TRACE_TRACE_CONFIGURATION;

    }
}

