/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;
import vivid.lib.I18n;
import vivid.lib.Primitives;
import vivid.lib.atlassian.ServletResponseAdapter;
import vivid.lib.atlassian.Servlets;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE20UnknownObject;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.TraceComponents;
import vivid.trace.datatypes.TraceConfigurations;
import vivid.trace.jira.servlets.PageServlet;
import vivid.trace.license.AddOnLicensing;
import vivid.trace.rest.TraceConfigurationResource;

public class TraceStandaloneHtmlPageServlet
extends PageServlet {
    private static final String VT_TRACE_WEB_RESOURCE_CONTEXT = "vt.trace";
    private final AddOnLicensing addOnLicensing;
    private final AddOnPreconditions addOnPreconditions;
    private final TraceConfigurations traceConfigurations;
    private static final String TRACE_CONFIGURATION_AO_SERVLET_ATTRIBUTE_KEY = "vivid.trace.trace-configuration-ao";

    public TraceStandaloneHtmlPageServlet(AddOnLicensing addOnLicensing, AddOnPreconditions addOnPreconditions, Factory factory, TraceConfigurations traceConfigurations) {
        super(factory);
        this.addOnLicensing = addOnLicensing;
        this.addOnPreconditions = addOnPreconditions;
        this.traceConfigurations = traceConfigurations;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Option<String> traceIdRaw = Servlets.firstPathInfoElement(request);
        if (traceIdRaw.isEmpty()) {
            Servlets.renderMessagesToServletResponse(response, MessageSet.of(VTE20UnknownObject.message(this.f.i18nResolverAdapterOption, "vivid.trace.phrase.trace-id", "(EMPTY TRACE ID)")));
            return;
        }
        Either<Message, Integer> traceIdOrMessage = Primitives.asIntegerOrMessage(I18n.getText(this.f.i18nResolverAdapterOption, "vivid.trace.phrase.trace-id", new Serializable[0]), traceIdRaw.get(), this.f.i18nResolverAdapterOption);
        Either<Void, Integer> traceIdOrResponse = Primitives.asTOrResponse(new ServletResponseAdapter(response), traceIdOrMessage);
        if (traceIdOrResponse.isLeft()) {
            return;
        }
        Either<Void, TraceConfigurationAO> traceConfigurationAOOrVTE20Response = TraceConfigurationResource.produceTraceConfigurationAOOrVTE20(new ServletResponseAdapter(response), traceIdRaw.get(), this.traceConfigurations, this.f);
        if (traceConfigurationAOOrVTE20Response.isLeft()) {
            return;
        }
        TraceConfigurationAO traceConfigurationAO = traceConfigurationAOOrVTE20Response.get();
        request.setAttribute(TRACE_CONFIGURATION_AO_SERVLET_ATTRIBUTE_KEY, (Object)traceConfigurationAO);
        this.f.getRequiredResources().requireContext(VT_TRACE_WEB_RESOURCE_CONTEXT);
        super.doGet(request, response);
    }

    @Override
    protected HashMap<String, Object> velocityParams(HttpServletRequest request) {
        java.util.Map<String, String> errorMessages = this.addOnPreconditions.getViolationsOfTypes(this.f.newHtmlMessageReportingAdapter(), MessageType.ERROR, new MessageType[0]).asMap();
        Map superVelocityParams = ((HashMap)super.velocityParams(request).merge(HashMap.ofAll(TraceComponents.licenseBannerVelocityParams(this.addOnLicensing, this.f)))).put("messages", errorMessages);
        Object traceConfigurationAOObject = request.getAttribute(TRACE_CONFIGURATION_AO_SERVLET_ATTRIBUTE_KEY);
        if (!(traceConfigurationAOObject instanceof TraceConfigurationAO)) {
            return superVelocityParams;
        }
        TraceConfigurationAO traceConfigurationAO = (TraceConfigurationAO)traceConfigurationAOObject;
        HashMap<String, String> myParams = HashMap.of("contextPath", this.f.getContextPath(), "defaultTraceConfiguration", TraceComponents.defaultTraceConfigurationJavaScriptEscaped(), "traceConfiguration", StringEscapeUtils.escapeEcmaScript((String)traceConfigurationAO.getConfiguration()), "traceId", traceConfigurationAO.getID(), "traceName", traceConfigurationAO.getName());
        return ((HashMap)superVelocityParams).merge(myParams);
    }
}

