/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.cs.params;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import vivid.lib.I18n;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE1JqlFunctionParameterValuesNotFound;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.cs.params.Parameter;
import vivid.trace.jql.grammar.CsJqlFnsParameterParser;

public class ProjectsParameter
implements Parameter<String> {
    private static final String PROJECT_PARAMETER_NAME = "project";
    private static final String PROJECT_PARAMETER_USAGE_I18N_KEY = "vivid.trace.jira.jql.cs.param.projects.usage";
    private final List<String> projectLiterals = new ArrayList<String>();

    public boolean hasValues() {
        return !this.projectLiterals.isEmpty();
    }

    public String toString() {
        return "ProjectsParameter" + this.projectLiterals + "";
    }

    @Override
    public void addParameterValue(String value) {
        this.projectLiterals.add(value);
    }

    @Override
    public Class<? extends ParserRuleContext> parserRuleContext() {
        return CsJqlFnsParameterParser.ComponentProjectParameterContext.class;
    }

    @Override
    public String name() {
        return PROJECT_PARAMETER_NAME;
    }

    @Override
    public String usageI18nKey() {
        return PROJECT_PARAMETER_USAGE_I18N_KEY;
    }

    public Collection<Project> validate(Option<ApplicationUser> searcher, Option<MessageSet> messageSetOption, String functionName, Factory factory) {
        ArrayList<Project> v = new ArrayList<Project>();
        ArrayList<String> inError = new ArrayList<String>();
        for (String rawValue : this.projectLiterals) {
            Either<MessageSet, Project> project = Jira.getProject(factory, rawValue, searcher);
            if (project.isRight()) {
                v.add(project.get());
                continue;
            }
            inError.add(rawValue);
        }
        if (!inError.isEmpty()) {
            MessageSet.addMessageTo(messageSetOption, VTE1JqlFunctionParameterValuesNotFound.message(factory.i18nResolverAdapterOption, functionName, I18n.getText(factory.i18nResolverAdapterOption, "vivid.trace.phrase.projects", new Serializable[0]), inError));
        }
        return v;
    }
}

