/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.ClauseSanitisingJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.I18n;
import vivid.lib.Strings;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE14JqlFunctionEmptyParameter;
import vivid.lib.messages.VTE19InternalError;
import vivid.lib.messages.VTE2JqlFunctionUnacceptedFunctionParameter;
import vivid.lib.messages.VTW4JqlFunctionNoSeedIssues;
import vivid.lib.messages.VTW6IssueCountSoftMaximumTruncation;
import vivid.lib.messages.VTW7InsufficientPermissionsTruncation;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.customfield.Direction;
import vivid.trace.customfield.DirectionsCFType;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.CaseInsensitiveANTLRInputStream;
import vivid.trace.jql.JqlMessageReportingAdapter;
import vivid.trace.jql.grammar.RelationsParameterLexer;
import vivid.trace.jql.grammar.RelationsParameterParser;
import vivid.trace.jql.relations.MemoizedArtifactTypes;
import vivid.trace.jql.relations.MemoizedIssueLinkTypes;
import vivid.trace.jql.relations.RelationsAlgorithm;
import vivid.trace.jql.relations.RelationsParameters;
import vivid.trace.jql.relations.RelationsParametersBuilderListener;
import vivid.trace.jql.relations.RelationsResults;
import vivid.trace.license.AddOnLicensing;

public abstract class AbstractRelationsJqlFunction
extends AbstractJqlFunction
implements ClauseSanitisingJqlFunction {
    private static final Logger log = LoggerFactory.getLogger(AbstractRelationsJqlFunction.class);
    private static final int ISSUE_LINK_DIRECTIONS = Direction.encode(EnumSet.of(Direction.INWARD_ISSUE_LINKS, Direction.OUTWARD_ISSUE_LINKS));
    private static final Pattern JQL_PARAMETER_PATTERN = Pattern.compile("^jql\\s*=(.*)", 66);
    private static final int JQL_PARAMETER_PATTERN_VALUE_GROUP = 1;
    private final AddOnLicensing addOnLicensing;
    private final AddOnPreconditions addOnPreconditions;
    protected final Factory f;
    private final ProjectConfigurations projectConfigurations;
    private final RelationsAlgorithm relationsAlgorithm;

    AbstractRelationsJqlFunction(AddOnLicensing addOnLicensing, AddOnPreconditions addOnPreconditions, Factory factory, ProjectConfigurations projectConfigurations, RelationsAlgorithm relationsAlgorithm) {
        this.addOnLicensing = addOnLicensing;
        this.addOnPreconditions = addOnPreconditions;
        this.f = factory;
        this.projectConfigurations = projectConfigurations;
        this.relationsAlgorithm = relationsAlgorithm;
    }

    private void addViolationsMessageSet(Option<MessageSet> messageSetOption, Option<RelationsParameters> relationsParametersOption) {
        if (messageSetOption.isDefined()) {
            MessageSet messages = this.addOnPreconditions.getViolationsOfTypes(new JqlMessageReportingAdapter(this.addOnLicensing, this.f, this.getFunctionName(), relationsParametersOption), MessageType.ERROR, MessageType.WARNING);
            messageSetOption.get().addAll(messages);
        }
    }

    private static Option<List<Issue>> allIssuesThatHaveDirections(CustomField directionsField, SearchService searchService, ApplicationUser searcher, Option<MessageSet> messageSetOption, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Query query = JqlQueryBuilder.newClauseBuilder().customField(directionsField.getIdAsLong()).notEq(Long.valueOf(0L)).buildQuery();
        try {
            List<Issue> issues = Jira.searchIssueResults(searchService, searcher, query);
            return Option.of(issues);
        }
        catch (SearchException e) {
            Message message = VTE19InternalError.message(i18nResolverAdapterOption, "Encountered an exception while querying for a list of issues that have relations: " + e.getMessage());
            MessageSet.addMessageTo(messageSetOption, message);
            log.debug(message.getMessage());
            return Option.none();
        }
    }

    protected abstract void applySpecialisation(RelationsParameters.Builder var1, Option<MessageSet> var2);

    void applyDirectionSpecialisation(RelationsParameters.Builder builder, Option<MessageSet> messageSetOption, EnumSet<Direction> absoluteDirections) {
        if (builder.hasAnyDirection()) {
            String paramExpr = "(direction" + (absoluteDirections.size() <= 1 ? " = " + absoluteDirections.iterator().next() : " in (" + absoluteDirections.stream().map(Direction::toString).collect(Collectors.joining(", ")) + ")") + ")";
            MessageSet.addMessageTo(messageSetOption, VTE2JqlFunctionUnacceptedFunctionParameter.message(this.f.i18nResolverAdapterOption, this.getFunctionName(), "direction", paramExpr));
        } else if (absoluteDirections.isEmpty()) {
            MessageSet.addMessageTo(messageSetOption, VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Attempt to apply empty direction specialisation in JQL function " + this.getFunctionName()));
        } else {
            builder.direction(RelationsParameters.Mode.ADDITIVE);
            for (Direction direction : absoluteDirections) {
                builder.direction(direction);
            }
        }
    }

    void applyInclusiveSpecialisation(RelationsParameters.Builder builder, Option<MessageSet> messageSetOption, boolean inclusiveValue) {
        if (builder.hasAnyInclusive()) {
            MessageSet.addMessageTo(messageSetOption, VTE2JqlFunctionUnacceptedFunctionParameter.message(this.f.i18nResolverAdapterOption, this.getFunctionName(), "inclusive", "(inclusive = " + inclusiveValue + ")"));
        } else {
            builder.inclusive(inclusiveValue);
        }
    }

    private void compileWarningMessages(Option<MessageSet> messageSetOption, RelationsResults results) {
        if (results.isInsufficientPermissions()) {
            MessageSet.addMessageTo(messageSetOption, VTW7InsufficientPermissionsTruncation.message(this.f.i18nResolverAdapterOption));
        }
        if (results.isIssueCountSoftMaximumTruncation()) {
            MessageSet.addMessageTo(messageSetOption, VTW6IssueCountSoftMaximumTruncation.message(this.f.i18nResolverAdapterOption, results.getIssueCountSoftMaximumOption().get()));
        }
    }

    @Nonnull
    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        RelationsResults results = this.search(Option.none(), queryCreationContext.getApplicationUser(), operand);
        return AbstractRelationsJqlFunction.transformIssueIdsIntoQueryLiterals(operand, results.getIssues());
    }

    private static boolean isAnActiveArtifactType(Issue issue, RelationsParameters params, MemoizedArtifactTypes memoizedArtifactTypes) {
        if (params.isArtifactTypesFullComplement()) {
            return true;
        }
        Collection<String> effectiveArtifactTypes = memoizedArtifactTypes.get(issue.getProjectObject());
        return effectiveArtifactTypes.contains(issue.getIssueTypeId());
    }

    private static boolean hasAnyOfTheEffectiveIssueLinkTypes(Issue issue, Collection<Long> effectiveIssueLinkTypesOverride, RelationsParameters params, IssueLinkManager issueLinkManager) {
        return params.getEffectiveDirections().contains((Object)Direction.INWARD_ISSUE_LINKS) && Jira.isAnyIssueLinkTypeTraversable(effectiveIssueLinkTypesOverride, issueLinkManager.getInwardLinks(issue.getId())) || params.getEffectiveDirections().contains((Object)Direction.OUTWARD_ISSUE_LINKS) && Jira.isAnyIssueLinkTypeTraversable(effectiveIssueLinkTypesOverride, issueLinkManager.getOutwardLinks(issue.getId()));
    }

    public static void parseArg(String arg, RelationsParameters.Builder builder, Option<MessageSet> messageSetOption, String functionName, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Matcher m = JQL_PARAMETER_PATTERN.matcher(arg.trim());
        if (m.matches()) {
            String value = Strings.unquoted(m.group(1).trim()).trim();
            if (value.isEmpty() && i18nResolverAdapterOption.isDefined()) {
                MessageSet.addMessageTo(messageSetOption, VTE14JqlFunctionEmptyParameter.message(i18nResolverAdapterOption, functionName, "jql", i18nResolverAdapterOption.get().getText("vivid.trace.jql-function-parameter.jql.usage", new Serializable[0])));
            }
            builder.jql(value);
        } else {
            RelationsParameterParser parser = AbstractRelationsJqlFunction.newParser(arg);
            parser.removeErrorListeners();
            RelationsParametersBuilderListener listener = new RelationsParametersBuilderListener(builder, messageSetOption, functionName, i18nResolverAdapterOption, parser);
            RelationsParameterParser.ParameterContext tree = parser.parameter();
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk(listener, tree);
        }
    }

    private static RelationsParameterParser newParser(String arg) {
        CaseInsensitiveANTLRInputStream input = new CaseInsensitiveANTLRInputStream(arg.trim());
        RelationsParameterLexer lexer = new RelationsParameterLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        return new RelationsParameterParser(tokens);
    }

    private static void parseArgs(List<String> args, RelationsParameters.Builder builder, Option<MessageSet> messageSetOption, String functionName, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        for (String arg : args) {
            AbstractRelationsJqlFunction.parseArg(arg, builder, messageSetOption, functionName, i18nResolverAdapterOption);
        }
    }

    @Nonnull
    public FunctionOperand sanitiseOperand(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand) {
        List args = functionOperand.getArgs();
        boolean sanitised = false;
        ArrayList<String> sanitisedArgs = new ArrayList<String>(args.size());
        for (String arg : args) {
            Query sanitisedQuery;
            Query query;
            String jqlQuery;
            SearchService.ParseResult parseResult;
            RelationsParameters.Builder builder = new RelationsParameters.Builder();
            AbstractRelationsJqlFunction.parseArg(arg, builder, Option.none(), this.getFunctionName(), Option.none());
            if (builder.hasAnyIssueLiterals()) {
                Issue issue = Jira.issueForArg(arg, searcher, true, this.f.jqlIssueSupport);
                if (issue != null && !this.f.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, searcher)) {
                    sanitisedArgs.add(issue.getId().toString());
                    sanitised = true;
                    continue;
                }
            } else if (builder.hasAnyJqlQueries() && (parseResult = this.f.searchService.parseQuery(searcher, jqlQuery = builder.jqlQueries.get(0))).isValid() && !(query = parseResult.getQuery()).equals((Object)(sanitisedQuery = this.f.searchService.sanitiseSearchQuery(searcher, query)))) {
                sanitisedArgs.add("jql = " + this.f.searchService.getJqlString(sanitisedQuery));
                sanitised = true;
                continue;
            }
            sanitisedArgs.add(arg);
        }
        return sanitised ? new FunctionOperand(functionOperand.getName(), sanitisedArgs) : functionOperand;
    }

    private RelationsResults search(Option<MessageSet> messageSetOption, ApplicationUser searcher, FunctionOperand operand) {
        RelationsParameters.Builder builder = new RelationsParameters.Builder();
        AbstractRelationsJqlFunction.parseArgs(operand.getArgs(), builder, messageSetOption, this.getFunctionName(), this.f.i18nResolverAdapterOption);
        if (messageSetOption.isDefined() && messageSetOption.get().hasMessagesOfTypes(MessageType.ERROR)) {
            return RelationsResults.EMPTY_RESULTS;
        }
        this.applySpecialisation(builder, messageSetOption);
        RelationsParameters parsedParameters = builder.build(messageSetOption, searcher, this.f, this.getFunctionName());
        this.addViolationsMessageSet(messageSetOption, Option.of(parsedParameters));
        if (messageSetOption.isDefined() && messageSetOption.get().hasMessagesOfTypes(MessageType.ERROR)) {
            return RelationsResults.EMPTY_RESULTS;
        }
        if (parsedParameters.isSeedIssuesSpecified()) {
            if (!parsedParameters.getSeedIssues().iterator().hasNext()) {
                MessageSet.addMessageTo(messageSetOption, VTW4JqlFunctionNoSeedIssues.message(this.f.i18nResolverAdapterOption, this.getFunctionName()));
                return RelationsResults.EMPTY_RESULTS;
            }
            return this.relationsAlgorithm.execute(parsedParameters, searcher, this.f.i18nResolverAdapterOption, false, Option.none(), Option.none(), Option.none());
        }
        RelationsResults.Builder results = new RelationsResults.Builder();
        CustomField field = DirectionsCFType.getCustomField(this.f.customFieldManager);
        Option<List<Issue>> searchResultIssues = AbstractRelationsJqlFunction.allIssuesThatHaveDirections(field, this.f.searchService, searcher, messageSetOption, this.f.i18nResolverAdapterOption);
        if (searchResultIssues.isEmpty()) {
            return RelationsResults.EMPTY_RESULTS;
        }
        LinkedHashSet<Long> issues = new LinkedHashSet<Long>();
        int availableDirections = Direction.encode(parsedParameters.getEffectiveDirections());
        MemoizedArtifactTypes memoizedArtifactTypes = new MemoizedArtifactTypes(parsedParameters, this.projectConfigurations);
        MemoizedIssueLinkTypes memoizedIssueLinkTypes = new MemoizedIssueLinkTypes(parsedParameters, this.projectConfigurations);
        for (Issue issue : searchResultIssues.get()) {
            boolean issueHasIssueLinkDirections;
            int directionsValue = ((Double)issue.getCustomFieldValue(field)).intValue();
            if (!AbstractRelationsJqlFunction.isAnActiveArtifactType(issue, parsedParameters, memoizedArtifactTypes) || !parsedParameters.isDirectionsFullComplement() && (directionsValue & availableDirections) == 0) continue;
            boolean bl = issueHasIssueLinkDirections = (directionsValue & ISSUE_LINK_DIRECTIONS) != 0;
            if (issueHasIssueLinkDirections && !parsedParameters.isIssueLinkTypesFullComplement() && !AbstractRelationsJqlFunction.hasAnyOfTheEffectiveIssueLinkTypes(issue, memoizedIssueLinkTypes.get(issue.getProjectObject()), parsedParameters, this.f.issueLinkManager)) continue;
            Either<Jira.Reason, Issue> x = Jira.getIssueSecure(issue, searcher, false, this.f.permissionManager);
            if (x.isLeft()) {
                if (x.getLeft() != Jira.Reason.InsufficientPermissions) continue;
                results.noteInsufficientPermissions();
                continue;
            }
            issues.add(issue.getId());
        }
        return results.issues(issues).build();
    }

    private static List<QueryLiteral> transformIssueIdsIntoQueryLiterals(FunctionOperand operand, Collection<Long> issues) {
        ArrayList<QueryLiteral> queryLiterals = new ArrayList<QueryLiteral>();
        if (issues != null) {
            for (Long issue : issues) {
                queryLiterals.add(new QueryLiteral((Operand)operand, issue));
            }
        }
        return queryLiterals;
    }

    @Nonnull
    public com.atlassian.jira.util.MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        MessageSet messageSet = new MessageSet();
        Option<MessageSet> messageSetOption = Option.of(messageSet);
        if (this.addOnPreconditions.hasViolationsOfTypes(MessageType.ERROR, new MessageType[0])) {
            messageSet.addAll(this.addOnPreconditions.getViolationsOfTypes(new JqlMessageReportingAdapter(this.addOnLicensing, this.f, this.getFunctionName(), Option.none()), MessageType.ERROR, new MessageType[0]));
        } else {
            RelationsResults results = this.search(messageSetOption, searcher, functionOperand);
            this.compileWarningMessages(messageSetOption, results);
        }
        return Jira.toJiraMessageSet(messageSetOption.get());
    }
}

