/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.LinkedHashSet;
import vivid.trace.customfield.Direction;
import vivid.trace.customfield.DirectionsCFType;
import vivid.trace.jql.relations.DefaultInclusiveStrategy;
import vivid.trace.jql.relations.RelationsParameters;

class DirectionFilteringInclusiveStrategy
extends DefaultInclusiveStrategy {
    private final CustomFieldManager customFieldManager;
    private final Direction direction;

    public DirectionFilteringInclusiveStrategy(Direction direction, CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
        this.direction = direction;
    }

    @Override
    public void execute(RelationsParameters params, LinkedHashSet<Long> visited) {
        if (params.isInclusive()) {
            CustomField directionsField = DirectionsCFType.getCustomField(this.customFieldManager);
            for (Issue seedIssue : params.getSeedIssues()) {
                Double directionsValue = (Double)seedIssue.getCustomFieldValue(directionsField);
                if (Direction.has(directionsValue, this.direction)) continue;
                visited.remove(seedIssue.getId());
            }
        } else {
            super.execute(params, visited);
        }
    }
}

