/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import com.atlassian.jira.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.jql.relations.RelationsParameters;

public class MemoizedArtifactTypes {
    private final RelationsParameters params;
    private final ProjectConfigurations projectConfigurations;
    private final Map<Long, Supplier<Collection<String>>> memo = new HashMap<Long, Supplier<Collection<String>>>();

    public MemoizedArtifactTypes(RelationsParameters params, ProjectConfigurations projectConfigurations) {
        this.params = params;
        this.projectConfigurations = projectConfigurations;
    }

    public Collection<String> get(Project project) {
        if (!this.params.isProjectConfigDeprecatedFlag()) {
            return this.params.getEffectiveArtifactTypes();
        }
        Long projectId = project.getId();
        if (!this.memo.containsKey(projectId)) {
            this.memo.put(projectId, () -> this.projectConfigurations.getEnabledArtifactTypeIds(project));
        }
        return this.memo.get(projectId).get();
    }
}

