/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.relations;

import io.vavr.control.Option;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import vivid.lib.I18n;
import vivid.lib.Strings;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE15JqlFunctionParameterSyntax;
import vivid.lib.messages.VTE3JqlFunctionIncorrectFunctionUsage;
import vivid.trace.customfield.Direction;
import vivid.trace.jql.grammar.RelationsParameterBaseListener;
import vivid.trace.jql.grammar.RelationsParameterParser;
import vivid.trace.jql.relations.RelationsParameters;

class RelationsParametersBuilderListener
extends RelationsParameterBaseListener {
    private final RelationsParameters.Builder builder;
    private final Option<MessageSet> messageSetOption;
    private final String functionName;
    private final Option<I18n.ResolverAdapter> i18nResolverAdapterOption;
    private boolean isErrorRecorded = false;
    private static final Map<String, String> FUNCTION_USAGE_MAP = io.vavr.collection.HashMap.of("links".toLowerCase(), "vivid.trace.jql-function.links.usage", "parents".toLowerCase(), "vivid.trace.jql-function.parents.usage", "relations".toLowerCase(), "vivid.trace.jql-function.relations.usage", "relatesWith".toLowerCase(), "vivid.trace.jql-function.relates-with.usage", "subtasks".toLowerCase(), "vivid.trace.jql-function.sub-tasks.usage").toJavaMap();
    private static final HashMap<Class<? extends RelationsParameterParser.ParameterContext>, Param> PARAMETER_USAGE_MAP = io.vavr.collection.HashMap.of(RelationsParameterParser.ArtifactTypeParameterContext.class, new Param("artifactType", "vivid.trace.jql-function-parameter.artifact.usage"), RelationsParameterParser.DirectionParameterContext.class, new Param("direction", "vivid.trace.jql-function-parameter.direction.usage"), RelationsParameterParser.DistanceParameterContext.class, new Param("distance", "vivid.trace.jql-function-parameter.distance.usage"), RelationsParameterParser.InclusiveParameterContext.class, new Param("inclusive", "vivid.trace.jql-function-parameter.inclusive.usage"), RelationsParameterParser.IssueLinkTypeParameterContext.class, new Param("issueLinkType", "vivid.trace.jql-function-parameter.issuelinktype.usage"), RelationsParameterParser.JqlParameterContext.class, new Param("jql", "vivid.trace.jql-function-parameter.jql.usage")).toJavaMap();

    RelationsParametersBuilderListener(RelationsParameters.Builder builder, Option<MessageSet> messageSetOption, String functionName, Option<I18n.ResolverAdapter> i18nResolverAdapterOption, RelationsParameterParser parser) {
        this.builder = builder;
        this.messageSetOption = messageSetOption;
        this.functionName = functionName;
        this.i18nResolverAdapterOption = i18nResolverAdapterOption;
        parser.addErrorListener(new MessageCollectingErrorListener());
    }

    private static String getUsageI18nKeyForFunction(String functionName) {
        return FUNCTION_USAGE_MAP.get(functionName.toLowerCase());
    }

    private static Option<Param> getUsageI18nKeyForParameterContext(ParseTree errorCtx) {
        for (ParseTree ctx = errorCtx; ctx != null && ctx != ctx.getParent(); ctx = ctx.getParent()) {
            if (!PARAMETER_USAGE_MAP.containsKey(ctx.getClass())) continue;
            return Option.of(PARAMETER_USAGE_MAP.get(ctx.getClass()));
        }
        return Option.none();
    }

    private void recordError(ParseTree context, int charPositionInLine) {
        if (this.isErrorRecorded) {
            return;
        }
        Option<Param> parameterInformation = RelationsParametersBuilderListener.getUsageI18nKeyForParameterContext(context);
        if (parameterInformation.isDefined()) {
            MessageSet.addMessageTo(this.messageSetOption, VTE15JqlFunctionParameterSyntax.message(this.i18nResolverAdapterOption, this.functionName, charPositionInLine, parameterInformation.get().name, I18n.getText(this.i18nResolverAdapterOption, parameterInformation.get().i18nKey, new Serializable[0])));
        } else {
            MessageSet.addMessageTo(this.messageSetOption, VTE3JqlFunctionIncorrectFunctionUsage.message(this.i18nResolverAdapterOption, this.functionName, I18n.getText(this.i18nResolverAdapterOption, RelationsParametersBuilderListener.getUsageI18nKeyForFunction(this.functionName), new Serializable[0])));
        }
        this.isErrorRecorded = true;
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        this.recordError(node.getParent(), node.getSymbol().getCharPositionInLine());
    }

    @Override
    public void exitArtifactTypeAdditive(RelationsParameterParser.ArtifactTypeAdditiveContext ctx) {
        this.builder.artifactType(RelationsParameters.Mode.ADDITIVE);
    }

    @Override
    public void exitArtifactTypeSubtractive(RelationsParameterParser.ArtifactTypeSubtractiveContext ctx) {
        this.builder.artifactType(RelationsParameters.Mode.SUBTRACTIVE);
    }

    @Override
    public void exitArtifacttype(RelationsParameterParser.ArtifacttypeContext ctx) {
        this.builder.artifactType(Strings.unquoted(ctx.string().getText()));
    }

    @Override
    public void exitDirectionAdditive(RelationsParameterParser.DirectionAdditiveContext ctx) {
        this.builder.direction(RelationsParameters.Mode.ADDITIVE);
    }

    @Override
    public void exitDirectionSubtractive(RelationsParameterParser.DirectionSubtractiveContext ctx) {
        this.builder.direction(RelationsParameters.Mode.SUBTRACTIVE);
    }

    @Override
    public void exitDirectionInward(RelationsParameterParser.DirectionInwardContext ctx) {
        this.builder.direction(Direction.INWARD_ISSUE_LINKS);
    }

    @Override
    public void exitDirectionOutward(RelationsParameterParser.DirectionOutwardContext ctx) {
        this.builder.direction(Direction.OUTWARD_ISSUE_LINKS);
    }

    @Override
    public void exitDirectionParents(RelationsParameterParser.DirectionParentsContext ctx) {
        this.builder.direction(Direction.PARENTS);
    }

    @Override
    public void exitDirectionSubtasks(RelationsParameterParser.DirectionSubtasksContext ctx) {
        this.builder.direction(Direction.SUBTASKS);
    }

    @Override
    public void exitDistance_p(RelationsParameterParser.Distance_pContext ctx) {
        if (ctx.exception == null) {
            this.builder.distance(ctx.INT().getText());
        }
    }

    @Override
    public void exitInclusiveYes(RelationsParameterParser.InclusiveYesContext ctx) {
        this.builder.inclusive(true);
    }

    @Override
    public void exitInclusiveNo(RelationsParameterParser.InclusiveNoContext ctx) {
        this.builder.inclusive(false);
    }

    @Override
    public void exitIssueLinkTypeAdditive(RelationsParameterParser.IssueLinkTypeAdditiveContext ctx) {
        this.builder.issueLinkType(RelationsParameters.Mode.ADDITIVE);
    }

    @Override
    public void exitIssueLinkTypeSubtractive(RelationsParameterParser.IssueLinkTypeSubtractiveContext ctx) {
        this.builder.issueLinkType(RelationsParameters.Mode.SUBTRACTIVE);
    }

    @Override
    public void exitIssuelinktype(RelationsParameterParser.IssuelinktypeContext ctx) {
        this.builder.issueLinkType(Strings.unquoted(ctx.string().getText()));
    }

    @Override
    public void exitIssue_p(RelationsParameterParser.Issue_pContext ctx) {
        this.builder.issue(ctx.getText());
    }

    @Override
    public void exitJqlquery(RelationsParameterParser.JqlqueryContext ctx) {
        this.builder.jql(Strings.unquoted(ctx.string().getText()));
    }

    @Override
    public void exitProjectConfigDeprecatedFlag(RelationsParameterParser.ProjectConfigDeprecatedFlagContext ctx) {
        this.builder.projectConfig();
    }

    private class MessageCollectingErrorListener
    extends BaseErrorListener {
        private MessageCollectingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            RelationsParametersBuilderListener.this.recordError(((RelationsParameterParser)recognizer).getContext(), charPositionInLine);
        }
    }

    private static class Param {
        final String name;
        final String i18nKey;

        Param(String name, String i18nKey) {
            this.name = name;
            this.i18nKey = i18nKey;
        }
    }
}

