/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.license;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import vivid.lib.I18n;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE21LicenseFormat;
import vivid.lib.messages.VTE22LicenseIncompatibleVersion;
import vivid.lib.messages.VTE23LicenseIncompatibleUsers;
import vivid.lib.messages.VTW14MaintenanceExpiration;
import vivid.license.LicenseType;
import vivid.license.LicenseV1;
import vivid.trace.components.AddOnInformation;
import vivid.trace.jira.gen.VividTraceForJiraProductIdentity;
import vivid.trace.jira.lib.Jira;
import vivid.trace.license.License;
import vivid.trace.license.LicenseFactory;

public class VividIssuedLicense
implements License {
    private final Option<String> rawLicenseKey;
    private final LicenseV1 license;
    private final Option<Integer> jiraActiveUserTier;
    static final LicenseFactory vividIssuedLicenseFactory = VividIssuedLicense::new;
    public static final String LICENSE_JIRA_USER_TIER_KEY = "jira-user-tier";
    public static final String LICENSE_JIRA_USER_TIER_UNLIMITED_VALUE = "unlimited";
    public static final String LICENSE_PRODUCT_KEY = "product";
    public static final String LICENSE_PRODUCT_VIVID_TRACE_VALUE = "vivid-trace";
    public static final int MAINTENANCE_EXPIRY_NOTICE_WINDOW_IN_DAYS = 7;

    protected VividIssuedLicense(Option<String> rawLicenseKey, LicenseV1 license, Option<Integer> jiraActiveUserTier) {
        this.rawLicenseKey = rawLicenseKey;
        this.license = license;
        this.jiraActiveUserTier = jiraActiveUserTier;
    }

    public static final Either<Message, VividIssuedLicense> fromRawLicenseKey(String rawLicenseKey, Option<Integer> jiraActiveUserTier, Option<I18n.ResolverAdapter> i18nResolverAdapterOption, LicenseFactory licenseFactory) {
        Objects.requireNonNull(rawLicenseKey);
        Either<Message, LicenseV1> licenseOption = LicenseV1.fromRawLicenseKey(rawLicenseKey, i18nResolverAdapterOption);
        if (licenseOption.isLeft()) {
            return Either.left(licenseOption.getLeft());
        }
        LicenseV1 license = licenseOption.get();
        Option<Message> vtpOption = VividIssuedLicense.vividTraceProduct(license, i18nResolverAdapterOption);
        if (vtpOption.isDefined()) {
            return Either.left(vtpOption.get());
        }
        return Either.right(licenseFactory.newLicense(Option.of(rawLicenseKey), license, jiraActiveUserTier));
    }

    private static Either<Message, Integer> jiraUserTier(LicenseV1 license, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Object jiraUserTierRaw = license.getAttributes().get(LICENSE_JIRA_USER_TIER_KEY);
        if (jiraUserTierRaw instanceof Integer) {
            return Either.right((Integer)jiraUserTierRaw);
        }
        if (jiraUserTierRaw instanceof String) {
            String str = (String)jiraUserTierRaw;
            if (LICENSE_JIRA_USER_TIER_UNLIMITED_VALUE.equalsIgnoreCase(str)) {
                return Either.right(Integer.MAX_VALUE);
            }
            try {
                return Either.right(Integer.valueOf(str));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Either.left(VTE21LicenseFormat.message(i18nResolverAdapterOption, "Jira user tier information is either missing or malformed"));
    }

    private static Option<Message> vividTraceProduct(LicenseV1 license, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Object product = license.getAttributes().get(LICENSE_PRODUCT_KEY);
        if (product instanceof String && LICENSE_PRODUCT_VIVID_TRACE_VALUE.equalsIgnoreCase(product.toString())) {
            return Option.none();
        }
        return Option.of(VTE21LicenseFormat.message(i18nResolverAdapterOption, "Product information is either missing or malformed"));
    }

    @Override
    public DateTime getIssueDate() {
        return this.license.getIssueDate();
    }

    @Override
    public String getIssuer(Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        return this.license.getIssuer();
    }

    @Override
    public Option<LicenseType> getLicenseType() {
        return LicenseType.valueForLabel(this.license.getLicenseType());
    }

    @Override
    public Option<DateTime> getMaintenanceExpiryDate() {
        return Option.of(this.license.getMaintenanceExpiryDate());
    }

    @Override
    public String getOrganization() {
        return this.license.getOrganization();
    }

    @Override
    public Option<String> getRawLicenseKeyOptional() {
        return this.rawLicenseKey;
    }

    @Override
    public Option<String> getSupportEntitlementNumber() {
        return Option.of(this.license.getVsen());
    }

    private boolean checkStatus(Option<MessageSet> messageSetOptional, Option<I18n.ResolverAdapter> i18nResolverAdapterOption, DateTimeFormatterFactory dateTimeFormatterFactory, AddOnInformation addOnInformation) {
        Either<Message, Integer> vtLicenseJiraUserTierEither;
        boolean isWithinMaintenanceWindow;
        DateTime maintenanceExpiryDate = this.license.getMaintenanceExpiryDate();
        boolean bl = isWithinMaintenanceWindow = !maintenanceExpiryDate.isBefore(this.productReleaseDate().toInstant());
        if (!isWithinMaintenanceWindow && messageSetOptional.isDefined()) {
            String formattedMaintenanceExpiryDate = Jira.formatDateForLoggedInUser(maintenanceExpiryDate, dateTimeFormatterFactory);
            String formattedProductReleaseDate = Jira.formatDateForLoggedInUser(this.productReleaseDate(), dateTimeFormatterFactory);
            messageSetOptional.get().add(VTE22LicenseIncompatibleVersion.message(i18nResolverAdapterOption, I18n.getText(i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.status.contrast-dates", new Serializable[]{addOnInformation.getAddOnVersion(), formattedProductReleaseDate, formattedMaintenanceExpiryDate})));
        }
        if ((vtLicenseJiraUserTierEither = VividIssuedLicense.jiraUserTier(this.license, i18nResolverAdapterOption)).isLeft()) {
            if (messageSetOptional.isDefined()) {
                messageSetOptional.get().add(vtLicenseJiraUserTierEither.getLeft());
            }
            return false;
        }
        int vtLicenseJiraUserTier = vtLicenseJiraUserTierEither.get();
        boolean isUserTierSatisfied = VividIssuedLicense.isPermissibleUserTier(vtLicenseJiraUserTier, this.jiraActiveUserTier, this.license);
        if (!isUserTierSatisfied && messageSetOptional.isDefined()) {
            messageSetOptional.get().add(VTE23LicenseIncompatibleUsers.message(i18nResolverAdapterOption, I18n.getText(i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.status.contrast-users", new Serializable[]{VividIssuedLicense.userTierAsString(vtLicenseJiraUserTier, i18nResolverAdapterOption), VividIssuedLicense.userTierAsString(this.jiraActiveUserTier.get(), i18nResolverAdapterOption)})));
        }
        return isWithinMaintenanceWindow && isUserTierSatisfied;
    }

    private static String userTierAsString(int userTier, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        return userTier == Integer.MAX_VALUE ? I18n.getText(i18nResolverAdapterOption, "vivid.phrase.unlimited", new Serializable[0]) : String.valueOf(userTier);
    }

    private static boolean isPermissibleUserTier(int vtLicenseJiraUserTier, Option<Integer> jiraActiveUserLimit, LicenseV1 license) {
        if (!jiraActiveUserLimit.isDefined()) {
            return false;
        }
        return jiraActiveUserLimit.get() <= vtLicenseJiraUserTier;
    }

    @Override
    public MessageSet getStatusMessages(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, DateTimeFormatterFactory dateTimeFormatterFactory, AddOnInformation addOnInformation) {
        MessageSet messages = new MessageSet();
        boolean isValid = this.checkStatus(Option.of(messages), i18nResolverAdapterOption, dateTimeFormatterFactory, addOnInformation);
        if (!isValid) {
            return messages;
        }
        if (this.isMaintenanceActive() && !this.isMaintenanceNearlyExpired()) {
            messages.add(new Message.MessageBuilder(MessageType.INFO, I18n.getText(i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.status.active-maintenance", new Serializable[0])).addDetail("supplementary-message", I18n.getText(i18nResolverAdapterOption, "vivid.trace.add-on-licensing.details.type.maintenance", new Serializable[]{Jira.formatDateForLoggedInUser(this.license.getMaintenanceExpiryDate(), dateTimeFormatterFactory)})).build());
        } else {
            VTW14MaintenanceExpiration.Variant type = this.isMaintenanceNearlyExpired() ? VTW14MaintenanceExpiration.Variant.NEARLY_EXPIRED : (this.isMaintenanceRecentlyExpired() ? VTW14MaintenanceExpiration.Variant.RECENTLY_EXPIRED : VTW14MaintenanceExpiration.Variant.EXPIRED);
            messages.add(VTW14MaintenanceExpiration.message(i18nResolverAdapterOption, this.license.getMaintenanceExpiryDate(), type, dateTimeFormatterFactory, this));
        }
        return messages;
    }

    public boolean isMaintenanceActive() {
        return this.isValid() && this.license.getMaintenanceExpiryDate().plusDays(1).isAfter(this.now());
    }

    boolean isMaintenanceNearlyExpired() {
        if (!this.isValid()) {
            return false;
        }
        Interval nearlyExpiredInterval = new Interval((ReadableInstant)this.license.getMaintenanceExpiryDate().minusDays(7), (ReadableInstant)this.license.getMaintenanceExpiryDate().plusDays(1));
        DateTime now = this.now();
        return nearlyExpiredInterval.contains(now);
    }

    boolean isMaintenanceRecentlyExpired() {
        if (!this.isValid()) {
            return false;
        }
        Interval recentlyExpiredInterval = new Interval((ReadableInstant)this.license.getMaintenanceExpiryDate().plusDays(1), (ReadableInstant)this.license.getMaintenanceExpiryDate().plusDays(8));
        DateTime now = this.now();
        return recentlyExpiredInterval.contains(now);
    }

    @Override
    public boolean isValid() {
        return this.checkStatus(Option.none(), null, null, null);
    }

    public DateTime now() {
        return DateTime.now();
    }

    protected DateTime productReleaseDate() {
        return VividTraceForJiraProductIdentity.RELEASE_DATE;
    }

    public Either<Message, Integer> getJiraUserTier(Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        return VividIssuedLicense.jiraUserTier(this.license, i18nResolverAdapterOption);
    }
}

