/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import vivid.lib.messages.Message;
import vivid.lib.rest.Rest;
import vivid.trace.components.Factory;
import vivid.trace.jira.servlets.ValidateXsrfToken;
import vivid.trace.license.AddOnLicensing;
import vivid.trace.license.VividIssuedLicense;
import vivid.trace.rest.AddOnResource;

@Path(value="addon/license")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tags(value={@Tag(name="addon", description="Vivid Trace for Jira add-on"), @Tag(name="license", description="Vivid Trace for Jira add-on licensing")})
public class AddOnLicenseResource {
    private final AddOnLicensing addOnLicensing;
    private final Factory f;
    @Context
    private HttpServletRequest httpServletRequest;

    @Inject
    public AddOnLicenseResource(AddOnLicensing addOnLicensing, Factory factory) {
        this.addOnLicensing = addOnLicensing;
        this.f = factory;
    }

    @GET
    @Operation(summary="Details of the currently active license applied to the Vivid Trace for Jira add-on", description="In the event that both a Vivid-issued license and an Atlassian-issued license are applied, Vivid-issued license details are given. The response may also include status messages.", operationId="getActiveLicenseDetails")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request succeeded: Replying with data", content={@Content(schema=@Schema(implementation=String.class, format="application/json"))}), @ApiResponse(responseCode="403", description="Lacking Jira System Administrator privilege")})
    @SecurityRequirement(name="jira-system-administrator")
    public Response getActiveLicenseDetails() {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Option<Response> responseOptional = AddOnResource.permissionViolationResponse(this.f);
        if (responseOptional.isDefined()) {
            return responseOptional.get();
        }
        return Rest.responseWithJSONEntity(Response.Status.OK, this.addOnLicensing.licensingStatus(Collections.EMPTY_LIST));
    }

    @PUT
    @Operation(summary="Apply a Vivid-issued license to the Vivid Trace for Jira add-on", description="A success response code indicates that the raw license text material was successfully reconstituted into a Vivid-issued license. Even then, the body might include messages pertaining to the validity of the license.", operationId="applyVividIssuedLicense")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request succeeded: Replying with data", content={@Content(schema=@Schema(implementation=String.class, format="application/json"))}), @ApiResponse(responseCode="400", description="Request could not be interpreted, contained invalid or unusable data, or product license is invalid, or some other condition"), @ApiResponse(responseCode="401", description="Authentication is required to proceed"), @ApiResponse(responseCode="403", description="Lacking Jira System Administrator privilege")})
    @SecurityRequirement(name="jira-system-administrator")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response applyVividIssuedLicense(@Parameter(description="A Vivid-issued license", required=true, schema=@Schema(type="string", format="raw license text material")) @QueryParam(value="rawLicenseKey") String rawLicenseKey) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Option<Response> responseOptional = AddOnResource.permissionViolationResponse(this.f);
        if (responseOptional.isDefined()) {
            return responseOptional.get();
        }
        Either<Message, VividIssuedLicense> result = this.addOnLicensing.setVividIssuedLicense(rawLicenseKey, this.f.i18nResolverAdapterOption);
        if (result.isLeft()) {
            return Rest.responseWithMessage(Response.Status.BAD_REQUEST, result.getLeft());
        }
        return Rest.responseWithJSONEntity(Response.Status.OK, this.addOnLicensing.licensingStatus(Collections.EMPTY_LIST));
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Operation(summary="Delete the Vivid-issued license from the add-on", description="Delete the Vivid-issued license currently applied to the Vivid Trace for Jira add-on. If the add-on no longer has any licenses applied to it, including licensing via the add-on host product, then this operation effectively sets the add-on in an unlicensed state, and users will no longer be able to make of use the add-on within the host product.", operationId="removeVividIssuedLicense")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request succeeded: Replying with data", content={@Content(schema=@Schema(implementation=String.class, format="application/json"))}), @ApiResponse(responseCode="401", description="Authentication is required to proceed"), @ApiResponse(responseCode="403", description="Lacking Jira System Administrator privilege")})
    @SecurityRequirement(name="jira-system-administrator")
    public Response removeVividIssuedLicense() {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Option<Response> responseOptional = AddOnResource.permissionViolationResponse(this.f);
        if (responseOptional.isDefined()) {
            return responseOptional.get();
        }
        this.addOnLicensing.removeVividIssuedLicense();
        return Rest.responseWithJSONEntity(Response.Status.OK, this.addOnLicensing.licensingStatus(Collections.EMPTY_LIST));
    }
}

