/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import vivid.lib.Strings;
import vivid.lib.atlassian.Rest;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTW15GraphTraversalTimeLimitElapsed;
import vivid.lib.messages.VTW6IssueCountSoftMaximumTruncation;
import vivid.lib.messages.VTW7InsufficientPermissionsTruncation;
import vivid.trace.components.AddOnConfiguration;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.TraceComponents;
import vivid.trace.customfield.Direction;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.jira.servlets.ValidateXsrfToken;
import vivid.trace.jql.relations.AbstractRelationsJqlFunction;
import vivid.trace.jql.relations.RelationsAlgorithm;
import vivid.trace.jql.relations.RelationsParameters;
import vivid.trace.jql.relations.RelationsResults;

@Path(value="graph")
@Consumes(value={"application/json"})
@Produces(value={"application/transit+json", "application/json"})
@Tag(name="graph", description="Execution of traces, and adjunct functions")
public class GraphResource {
    private static final Map<String, Direction> DIRECTIONS_MAP = io.vavr.collection.HashMap.of("inward", Direction.INWARD_ISSUE_LINKS, "outward", Direction.OUTWARD_ISSUE_LINKS, "parents", Direction.PARENTS, "subtasks", Direction.SUBTASKS).toJavaMap();
    private static final String DISTANCE_UNLIMITED_VALUE = "";
    private final AddOnConfiguration addOnConfiguration;
    private final AddOnPreconditions addOnPreconditions;
    private final Factory f;
    @Context
    private HttpServletRequest httpServletRequest;
    private final RelationsAlgorithm relationsAlgorithm;
    private final TraceComponents traceComponents;

    @Inject
    public GraphResource(AddOnConfiguration addOnConfiguration, AddOnPreconditions addOnPreconditions, Factory factory, RelationsAlgorithm relationsAlgorithm, TraceComponents traceComponents) {
        this.addOnConfiguration = addOnConfiguration;
        this.addOnPreconditions = addOnPreconditions;
        this.f = factory;
        this.relationsAlgorithm = relationsAlgorithm;
        this.traceComponents = traceComponents;
    }

    @Path(value="relations")
    @GET
    @Operation(summary="Execute a parameterized trace", description="Executes a trace according to the supplied tracing criteria. When no seed issues are supplied, an empty result is returned along with the requested issue fields.", operationId="getRelationGraph")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Trace results", content={@Content(mediaType="application/transit+json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="403", description="Refusing access to requested resource, perhaps due to insufficient privilege (Caller is assumed to know that the resource might exist)"), @ApiResponse(responseCode="403", description="Lacking Jira System Administrator privilege"), @ApiResponse(responseCode="404", description="Requested resource was not found")})
    @SecurityRequirement(name="jira-browse-project")
    public Response getRelationGraph(@Parameter(description="Enable and follow only certain artifact types during tracing.") @QueryParam(value="artifactTypes") String artifactTypes, @Parameter(description="Relationship directions to follow during tracing. An empty value indicates all directions.") @QueryParam(value="directions") String directions, @Parameter(description="Number of hops away from the seed issues as the outer limit to run the trace. An empty value indicates unlimited distance.") @QueryParam(value="distance") @DefaultValue(value="") String distance, @Parameter(description="When true, include seed issues in the results.") @QueryParam(value="includeSeedIssues") @DefaultValue(value="true") String includeSeedIssues, @Parameter(description="Enable and follow only certain issue link types during tracing.") @QueryParam(value="issueLinkTypes") String issueLinkTypes, @Parameter(description="Display item field data in the relation graph according to this layout.") @QueryParam(value="itemCardLayout") @DefaultValue(value="[{:id \":jira.issue-field.system/issue-type\" :x 0 :y 0 :w 1 :h 1}{:id \":jira.issue-field.system/key\" :x 1 :y 0 :w 4 :h 1}{:id \":jira.issue-field.system/assignee\" :x 5 :y 0 :w 5 :h 1}{:id \":jira.issue-field.system/priority\" :x 0 :y 1 :w 1 :h 1}{:id \":jira.issue-field.system/summary\" :x 1 :y 1 :w 9 :h 2}]") String itemCardLayout, @Parameter(description="An argument passed to relations() whose issue results become the seed issues for the trace") @QueryParam(value="relationsSeedIssuesArg") String relationsSeedIssuesArg) throws IOException {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Option<Response> vteOption = this.addOnPreconditionsErrorViolations();
        if (vteOption.isDefined()) {
            return vteOption.get();
        }
        if (Strings.isBlank(Strings.unquoted(relationsSeedIssuesArg))) {
            return vivid.lib.rest.Rest.responseWithJSONEntity(Response.Status.OK, Collections.singletonMap("itemCardLayout", itemCardLayout));
        }
        ApplicationUser searcher = this.f.jiraAuthenticationContext.getLoggedInUser();
        RelationsParameters.Builder builder = new RelationsParameters.Builder();
        if (directions != null && !directions.isEmpty()) {
            builder.direction(RelationsParameters.Mode.ADDITIVE);
            Collection<String> directionStrings = Jackson.readValue(directions, new Jackson.TypeReference<Collection<String>>(){});
            for (String string : directionStrings) {
                builder.direction(DIRECTIONS_MAP.get(string));
            }
        }
        if (distance != null && !distance.isEmpty()) {
            builder.distance(distance);
        }
        boolean includeSeedIssuesPrimitive = Boolean.parseBoolean(includeSeedIssues);
        builder.inclusive(includeSeedIssuesPrimitive);
        if (!Strings.isBlank(artifactTypes)) {
            Collection<String> enabledArtifactTypes = Jackson.readValue(artifactTypes, new Jackson.TypeReference<Collection<String>>(){});
            builder.artifactType(RelationsParameters.Mode.ADDITIVE);
            for (String id : enabledArtifactTypes) {
                builder.artifactType(id);
            }
        }
        if (!Strings.isBlank(issueLinkTypes)) {
            Collection<String> enabledIssueLinkTypes = Jackson.readValue(issueLinkTypes, new Jackson.TypeReference<Collection<String>>(){});
            builder.issueLinkType(RelationsParameters.Mode.ADDITIVE);
            for (String id : enabledIssueLinkTypes) {
                builder.issueLinkType(id);
            }
        }
        MessageSet messageSet = new MessageSet();
        AbstractRelationsJqlFunction.parseArg(StringEscapeUtils.unescapeJava((String)Strings.unquoted(relationsSeedIssuesArg)), builder, Option.of(messageSet), "relations", this.f.i18nResolverAdapterOption);
        RelationsParameters relationsParameters = builder.build(Option.of(messageSet), searcher, this.f, "relations");
        MyTraversalAdapterObserver myTraversalAdapterObserver = new MyTraversalAdapterObserver(itemCardLayout, includeSeedIssuesPrimitive ? Option.none() : Option.of(relationsParameters.getSeedIssues()), this.f);
        if (!messageSet.hasMessagesOfTypes(MessageType.ERROR)) {
            int issueCountSoftMaximum = this.addOnConfiguration.getIssueCountSoftMaximum();
            int graphTraversalTimeLimit = this.addOnConfiguration.getGraphTraversalTimeLimit();
            RelationsResults results = this.relationsAlgorithm.execute(relationsParameters, searcher, this.f.i18nResolverAdapterOption, false, Option.of(myTraversalAdapterObserver), Option.of(issueCountSoftMaximum), Option.of(graphTraversalTimeLimit));
            if (results.isIssueCountSoftMaximumTruncation()) {
                messageSet.add(VTW6IssueCountSoftMaximumTruncation.message(this.f.i18nResolverAdapterOption, issueCountSoftMaximum));
            }
            if (results.isInsufficientPermissions()) {
                messageSet.add(VTW7InsufficientPermissionsTruncation.message(this.f.i18nResolverAdapterOption));
            }
            if (results.isGraphTraversalTimeLimitElapsed()) {
                messageSet.add(VTW15GraphTraversalTimeLimitElapsed.message(this.f.i18nResolverAdapterOption, graphTraversalTimeLimit));
            }
        }
        io.vavr.collection.Map<String, Object> graphBuilder = this.traceComponents.issueRelationGraphDescription(itemCardLayout, messageSet, myTraversalAdapterObserver.getFilteredRelations(), myTraversalAdapterObserver.getIssues(), myTraversalAdapterObserver.getIssueAttributeCollector(), searcher);
        return Rest.responseWithEntity(this.httpServletRequest, Response.Status.OK, graphBuilder.toJavaMap());
    }

    private Option<Response> addOnPreconditionsErrorViolations() {
        MessageSet errorMessages = this.addOnPreconditions.getViolationsOfTypes(this.f.newHtmlMessageReportingAdapter(), MessageType.ERROR, new MessageType[0]);
        if (!errorMessages.isEmpty()) {
            return Option.of(vivid.lib.rest.Rest.responseWithMessage(Response.Status.FORBIDDEN, errorMessages));
        }
        return Option.none();
    }

    private static class MyTraversalAdapterObserver
    implements RelationsAlgorithm.TraversalAdapterObserver {
        final Map<String, Map<String, Object>> issues = new HashMap<String, Map<String, Object>>();
        final Map<Long, String> issueIdToKey = new HashMap<Long, String>();
        final Set<Relation> relations;
        final IssueFieldCollector issueFieldCollector;
        final Set<Long> ignoreIssueIds = new HashSet<Long>();

        MyTraversalAdapterObserver(String itemCardLayout, Option<Iterable<Issue>> ignoreIssuesOption, Factory f) {
            if (ignoreIssuesOption.isDefined()) {
                for (Issue issue : ignoreIssuesOption.get()) {
                    this.ignoreIssueIds.add(issue.getId());
                }
            }
            this.relations = new HashSet<Relation>();
            this.issueFieldCollector = new IssueFieldCollector(itemCardLayout, f);
        }

        @Override
        public void markedVertex(Issue issue) {
            if (this.ignoreIssueIds.contains(issue.getId())) {
                return;
            }
            this.issueIdToKey.put(issue.getId(), issue.getKey());
            Map<String, Object> attributes = this.issueFieldCollector.collectAttributesForIssue(issue);
            this.issues.put(issue.getKey(), attributes);
        }

        @Override
        public void notedRelation(Issue outwardIssue, String relationName, Issue inwardIssue) {
            this.relations.add(new Relation(outwardIssue.getId(), relationName, inwardIssue.getId()));
        }

        Collection<List<String>> getFilteredRelations() {
            ArrayList<List<String>> filteredRelations = new ArrayList<List<String>>();
            for (Relation relation : this.relations) {
                boolean outwardIsMarked = this.issueIdToKey.containsKey(relation.outwardIssueId);
                boolean inwardIsMarked = this.issueIdToKey.containsKey(relation.inwardIssueId);
                if (!outwardIsMarked || !inwardIsMarked) continue;
                filteredRelations.add(Arrays.asList(this.issueIdToKey.get(relation.outwardIssueId), relation.relationName, this.issueIdToKey.get(relation.inwardIssueId)));
            }
            return filteredRelations;
        }

        IssueFieldCollector getIssueAttributeCollector() {
            return this.issueFieldCollector;
        }

        Map<String, Map<String, Object>> getIssues() {
            return this.issues;
        }
    }

    private static class Relation {
        final Long outwardIssueId;
        final String relationName;
        final Long inwardIssueId;

        private Relation(Long outwardIssueId, String relationName, Long inwardIssueId) {
            this.outwardIssueId = outwardIssueId;
            this.relationName = relationName;
            this.inwardIssueId = inwardIssueId;
        }

        public int hashCode() {
            return 31 * this.outwardIssueId.hashCode() + this.inwardIssueId.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Relation that = (Relation)o;
            return this.outwardIssueId.equals(that.outwardIssueId) && this.inwardIssueId.equals(that.inwardIssueId) && this.relationName.compareTo(that.relationName) == 0;
        }
    }
}

