/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.VTE20UnknownObject;
import vivid.lib.rest.Rest;
import vivid.trace.accesscontrols.TraceVisibilityAccessControl;
import vivid.trace.components.AddOnConfiguration;
import vivid.trace.components.Factory;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.components.Providers;
import vivid.trace.data.ContextualTraceConfigurationQuickList;
import vivid.trace.jira.servlets.ValidateXsrfToken;

@Path(value="project")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="project", description="Trace configurations of projects")
public class ProjectResource {
    private final AddOnConfiguration addOnConfiguration;
    private final ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList;
    private final Factory f;
    @Context
    private HttpServletRequest httpServletRequest;
    private final ProjectConfigurations projectConfigurations;
    private final TraceVisibilityAccessControl traceVisibilityAccessControl;
    private static final Providers.Provider<MyContext> CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "contextual-trace-configuration-quick-list";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            String addonValue = context.env.contextualTraceConfigurationQuickList.getAddonComputedValue();
            Option<String> projectValue = context.env.contextualTraceConfigurationQuickList.getProjectRawValue(context.project);
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("addon", addonValue);
            if (projectValue.isDefined()) {
                res.put("project", projectValue.get());
            }
            accumulator.put(this.getKey(), Collections.unmodifiableMap(res));
        }
    };
    private static final Providers.Provider<MyContext> IS_USER_JIRA_ADMIN = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "isUserJiraAdmin";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), ((ProjectResource)context.env).f.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, ((ProjectResource)context.env).f.jiraAuthenticationContext.getLoggedInUser()));
        }
    };
    private static final Providers.Provider<MyContext> ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "issue-context-trace-display-format";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            String addonValue = context.env.addOnConfiguration.getIssueContextTraceDisplayFormat();
            Option<String> projectValue = context.env.projectConfigurations.getIssueContextTraceDisplayFormat(context.project);
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("addon", addonValue);
            if (projectValue.isDefined()) {
                res.put("project", projectValue.get());
            }
            accumulator.put(this.getKey(), Collections.unmodifiableMap(res));
        }
    };
    private static final Providers.Provider<MyContext> PROJECT_CONTEXTUAL_TRACE_VISIBILITY = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "trace-visibility";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            Collection<Map<String, String>> addonValue = context.env.traceVisibilityAccessControl.getForAddOn(TraceVisibilityAccessControl.OptionalFields.NAME);
            Option<Collection<Map<String, String>>> projectValue = context.env.traceVisibilityAccessControl.getForProject(context.project, TraceVisibilityAccessControl.OptionalFields.NAME);
            HashMap<String, Collection<Map<String, String>>> res = new HashMap<String, Collection<Map<String, String>>>();
            res.put("addon", addonValue);
            if (projectValue.isDefined()) {
                res.put("project", projectValue.get());
            }
            accumulator.put(this.getKey(), Collections.unmodifiableMap(res));
        }
    };
    private static final Providers<MyContext> PROVIDERS = new Providers(Arrays.asList(CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST, IS_USER_JIRA_ADMIN, ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT, PROJECT_CONTEXTUAL_TRACE_VISIBILITY));

    @Inject
    public ProjectResource(AddOnConfiguration addOnConfiguration, ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList, Factory factory, ProjectConfigurations projectConfigurations, TraceVisibilityAccessControl traceVisibilityAccessControl) {
        this.addOnConfiguration = addOnConfiguration;
        this.contextualTraceConfigurationQuickList = contextualTraceConfigurationQuickList;
        this.f = factory;
        this.projectConfigurations = projectConfigurations;
        this.traceVisibilityAccessControl = traceVisibilityAccessControl;
    }

    private static Either<Response, Project> projectByIdOrKey(String rawValue, Factory f) {
        Project project = null;
        try {
            Long projectId = Long.valueOf(rawValue);
            project = f.projectManager.getProjectObj(projectId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (project == null) {
            project = f.projectManager.getProjectObjByKey(rawValue);
        }
        return project != null ? Either.right(project) : Either.left(Rest.responseWithMessage(Response.Status.NOT_FOUND, VTE20UnknownObject.message(f.i18nResolverAdapterOption, "vivid.phrase.project-key", rawValue)));
    }

    private Either<Response, Project> projectPermissionViolationResponse(String projectIdOrKey, ProjectPermissionKey projectPermissionKey) {
        Either<Response, Project> project = ProjectResource.projectByIdOrKey(projectIdOrKey, this.f);
        if (project.isRight() && !this.f.permissionManager.hasPermission(projectPermissionKey, project.get(), this.f.jiraAuthenticationContext.getLoggedInUser())) {
            return Either.left(Rest.responseWithMessage(Response.Status.FORBIDDEN, VTE20UnknownObject.message(this.f.i18nResolverAdapterOption, "vivid.phrase.project-key", projectIdOrKey)));
        }
        return project;
    }

    private Response currentProjectConfiguration(Project project, List<String> keys) {
        MyContext context = new MyContext(this.addOnConfiguration, project, this);
        Map<String, Object> configuration = PROVIDERS.fulfill(keys, context);
        return Rest.responseWithJSONEntity(Response.Status.OK, configuration);
    }

    @Path(value="{project}")
    @GET
    @Operation(summary="Get specific values from a trace configuration for a specific project", operationId="getProjectConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Trace configuration for the specified project", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="403", description="Refusing access to requested resource, perhaps due to insufficient privilege (Caller is assumed to know that the resource might exist)"), @ApiResponse(responseCode="404", description="Requested resource was not found")})
    @SecurityRequirement(name="jira-browse-project")
    public Response getProjectConfiguration(@Parameter(description="Jira project ID or key", required=true) @PathParam(value="project") String projectIdOrKey, @Parameter(description="Obtains values corresponding to these keys from a project's configuration") @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Either<Response, Project> project = this.projectPermissionViolationResponse(projectIdOrKey, ProjectPermissions.BROWSE_PROJECTS);
        return project.isRight() ? this.currentProjectConfiguration(project.get(), keys) : project.getLeft();
    }

    @Path(value="{project}")
    @PUT
    @Operation(summary="Set the entire trace configuration for a specific project", operationId="setProjectConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The updated trace configuration for the specified keys in the project", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="403", description="Refusing access to requested resource, perhaps due to insufficient privilege (Caller is assumed to know that the resource might exist)"), @ApiResponse(responseCode="404", description="Requested resource was not found")})
    @SecurityRequirement(name="jira-administer-project")
    public Response setProjectConfiguration(@Parameter(description="Jira project ID or key", required=true) @PathParam(value="project") String projectIdOrKey, @RequestBody(description="Changed portions of the project trace configuration", required=true, content={@Content(schema=@Schema(implementation=ProjectConfiguration.class))}) String deltaStr) throws IOException {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Either<Response, Project> project = this.projectPermissionViolationResponse(projectIdOrKey, ProjectPermissions.ADMINISTER_PROJECTS);
        if (project.isLeft()) {
            return project.getLeft();
        }
        Map<String, Object> delta = Jackson.readValue(deltaStr != null ? deltaStr : "{}", new Jackson.TypeReference<Map<String, Object>>(){});
        if (delta.containsKey("artifactTypes")) {
            this.projectConfigurations.setEnabledArtifactTypes(project.get(), (Collection)delta.get("artifactTypes"));
        }
        if (delta.containsKey("contextual-trace-configuration-quick-list")) {
            this.projectConfigurations.setContextualTraceConfigurationQuickList(project.get(), (String)delta.get("contextual-trace-configuration-quick-list"));
        }
        if (delta.containsKey("issue-context-trace-display-format")) {
            this.projectConfigurations.setIssueContextTraceDisplayFormat(project.get(), (String)delta.get("issue-context-trace-display-format"));
        }
        if (delta.containsKey("issueLinkTypes")) {
            this.projectConfigurations.setEnabledIssueLinkTypes(project.get(), (Collection)delta.get("issueLinkTypes"));
        }
        if (delta.containsKey("itemCardLayout")) {
            this.projectConfigurations.setItemCardLayout(project.get(), (String)delta.get("itemCardLayout"));
        }
        if (delta.containsKey("trace-visibility")) {
            this.traceVisibilityAccessControl.setForProject(project.get(), (Collection)delta.get("trace-visibility"));
        }
        return this.currentProjectConfiguration(project.get(), new ArrayList<String>(delta.keySet()));
    }

    @Path(value="{project}")
    @DELETE
    @Consumes(value={"*/*"})
    @Operation(summary="Deletes specified settings keys in a project", operationId="deleteProjectConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The updated trace configuration for the specified keys in the project", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="403", description="Refusing access to requested resource, perhaps due to insufficient privilege (Caller is assumed to know that the resource might exist)"), @ApiResponse(responseCode="404", description="Requested resource was not found")})
    @SecurityRequirement(name="jira-administer-project")
    public Response deleteProjectConfiguration(@Parameter(description="Jira project ID or key", required=true) @PathParam(value="project") String projectIdOrKey, @Parameter(description="Project configuration keys to delete") @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Either<Response, Project> project = this.projectPermissionViolationResponse(projectIdOrKey, ProjectPermissions.ADMINISTER_PROJECTS);
        if (project.isLeft()) {
            return project.getLeft();
        }
        this.projectConfigurations.delete(project.get(), keys);
        return this.currentProjectConfiguration(project.get(), keys);
    }

    private static class MyContext {
        final AddOnConfiguration addOnConfiguration;
        final Project project;
        final ProjectResource env;

        private MyContext(AddOnConfiguration addOnConfiguration, Project project, ProjectResource env) {
            this.addOnConfiguration = addOnConfiguration;
            this.project = project;
            this.env = env;
        }
    }

    @Schema(description="The trace configuration of a project")
    public static class ProjectConfiguration {
        @Schema(name="contextual-trace-configuration-quick-list")
        String contextualTraceConfigurationQuickList;
        @Schema(name="issue-context-trace-display-format")
        IssueContextTraceDisplayFormat issueContextTraceDisplayFormat;
        @Schema(name="trace-visibility")
        List<Principal> traceVisibility;

        public String getContextualTraceConfigurationQuickList() {
            return this.contextualTraceConfigurationQuickList;
        }

        public IssueContextTraceDisplayFormat getIssueContextTraceDisplayFormat() {
            return this.issueContextTraceDisplayFormat;
        }

        public List<Principal> getTraceVisibility() {
            return this.traceVisibility;
        }
    }

    static class Principal {
        ACPrincipalEnum type;
        String id;

        Principal() {
        }

        public ACPrincipalEnum getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }

    static enum ACPrincipalEnum {
        GROUP,
        PROJECT_ROLE,
        SYSTEM,
        USER;


        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }

    static enum IssueContextTraceDisplayFormat {
        ISSUETABPANEL,
        WEBPANEL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

