// Copyright 2025 Vivid Inc. and/or its affiliates.

"use strict";

if (typeof VT == 'undefined') {
    var VT = {};
}
if (typeof VT.Atlassian == 'undefined') {
    VT.Atlassian = {};
}

// When this JS file is requested by a client, the <transformer key="jsI18n"/> directive in
// atlassian-plugin.xml causes calls to AJS.I18n.getText() with hardcoded string I18n keys
// (exactly as you see here) to be substituted with their localized string values according
// to the current locale of that session.
//
// Isolating such processing of our resource files to minimal, purpose-specific files like
// this one curtails the potential for processing problems the remaining portions of our other resource files.
VT.Atlassian.i18nTable = {
    'admin.issuelinking.inward.description' : AJS.I18n.getText('admin.issuelinking.inward.description'),
    'admin.issuelinking.outward.description': AJS.I18n.getText('admin.issuelinking.outward.description'),
    'common.concepts.issuelinktype'         : AJS.I18n.getText('common.concepts.issuelinktype'),
    //'': AJS.I18n.getText(''),
};

VT.Atlassian.i18nGetText = function (key) {
    return VT.Atlassian.i18nTable[key] || '👻 ' + key;
}
